<?php
/*--------------------------------------------------------------
   Item.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial;

use Gambio\Admin\Modules\Statistics\Model\Collections\SerialItemValues;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Item\Title;

class Item
{
    /**
     * @var Title
     */
    private $title;
    
    /**
     * @var SerialItemValues
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(Title $title, SerialItemValues $values)
    {
        $this->title  = $title;
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Title $title, SerialItemValues $values): self
    {
        return new self($title, $values);
    }
    
    
    /**
     * Return title.
     */
    public function title(): Title
    {
        return $this->title;
    }
    
    
    /**
     * Return values.
     */
    public function values(): SerialItemValues
    {
        return $this->values;
    }
}